function time = scaleTime(seconds)
% DESCRIPTION:
%       Function to scale a scalar number of seconds into days, hours,
%       minutes, and seconds, and return a string with this information
%
% USAGE:
%       time = scaleTime(seconds)
%
% INPUTS:
%       seconds         - number of seconds
%
% OUTPUTS:
%       time            - string of scaled time   
%
% ABOUT:
%       author          - Bradley Treeby
%       date            - 16th July 2009
%       last update     - 16th July 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)

hours = floor(seconds / (60*60));
seconds = seconds - hours*60*60;
minutes = floor( seconds / 60 );
seconds = seconds - minutes*60;

if hours > 0
    time = [num2str(hours) 'hours ' num2str(minutes) 'min ' num2str(seconds) 's'];
elseif minutes > 0
    time = [num2str(minutes) 'min ' num2str(seconds) 's']; 
else
    time = [num2str(seconds) 's']; 
end